# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
import json
from django.conf import settings
from mysite.utils import get_option
class DogService(object):
    u"""【加密狗信息】获取总点数，考勤点数，消费点数及客户编码"""
    @ladonize(rtype=str)
    def get_dog_info(self):
        '''
                    获取授权信息
        @rtype: 返回信息
            0    成功
            -181    获取zkeco授权许可失败
            {"data": {"count": 103, "zktime_count": 100, "customer_info": "ZK2013TS", "zkpos_count": 3}, "option": "get_dog_info", "ret": "ok"}
        '''
        from mysite.authorize_fun import get_cache
        
        RET_INFO={}
        RET_INFO['option'] = 'get_dog_info'
        DATA = {}
        try:
            count = 0
            zkeco_count = get_cache("ZKECO_DEVICE_LIMIT") or 0
            zktime_count = get_cache("ATT_DEVICE_LIMIT") or 0
            zkpos_count = get_cache("POS_DEVICE_LIMIT") or 0
            customer_info = settings.CUSTOMER_CODE
            if zkeco_count != 0:
                count = zkeco_count
            else:
                if get_option("POS"):
                    count += zkpos_count
                    DATA['zkpos_count'] = zkpos_count
                    DATA['zkpos_version'] = get_option("zkpos_version")
                if get_option("ATT"):
                    count += zktime_count
                    DATA['zktime_count'] = zktime_count
                    DATA['zktime_version'] = get_option("zktime_version")
            DATA['count'] = count
            DATA['customer_info'] = customer_info
            DATA['zkeco_version'] = get_option("zkeco_version")
            RET_INFO['data'] = DATA
            RET_INFO['ret'] = "0"
        except:
            RET_INFO["ret"] = '-181'
        return json.dumps(RET_INFO)
